* Definicia indexovych mnozin
Set i /X,Y,K,L,TX,D/
    m /1*2/
    l /GJM,ALT/;

alias (i,j)
alias (m,m1)

* Definicia parametrov
Parameter B0(i,j),B1(i,j),x0(j),x1(j),y1(i);
$libinclude xlimport B0 C:\MaxEnt\Data\SAM_example.xls data!b3:h9
$libinclude xlimport B1 C:\MaxEnt\Data\SAM_example.xls data!b16:h22
$libinclude xlimport x0 C:\MaxEnt\Data\SAM_example.xls data!c12:h13
$libinclude xlimport x1 C:\MaxEnt\Data\SAM_example.xls data!c25:h26

Parameter A0(i,j),A1(i,j);
    A0(i,j)=0;
    A0(i,j)$x0(j)=B0(i,j)/x0(j);

    A1(i,j)=B1(i,j)/x1(j);

Scalar G0,G1,N1,N5,F;
    G0=sum(j, x0(j));
    G1=sum(j, x1(j));

    N1=sum((i,j), 1);
    N5=sum(m, 1);

    F=G1;
    G1=G1/F;

    x1(j)=x1(j)/F;
    y1(i)=x1(i);

Parameter zero(i,j);
$libinclude xlimport zero C:\MaxEnt\Data\SAM_example.xls data!c29:i35

zero('D','D')=0;
zero('TX','D')=0;

Parameter Z_GJM(i,j,m),Z_ALT(i,j,m);
    Z_GJM(i,j,'1') = 1e-10;
    Z_GJM(i,j,'2') = 1;

    Z_ALT(i,j,m)=Z_GJM(i,j,m);

*    Z_GJM(i,j,'1')=max(0,(x1(j)-(G1-y1(i)))/x1(j));
*    Z_GJM(i,j,'2')=min(1,x1(j)/y1(i))*y1(i)/x1(j);

*    Z_ALT(i,j,'1')=max(1e-10,(x1(j)-(G1-y1(i)))/G1);
*    Z_ALT(i,j,'2')=(min(1,x1(j)/y1(i)))*y1(i)/G1;

Parameter N4(i,j);

* Definicia premennych a rovnic
Variables
    lambda(i)
    mi(j)
    gamma(i,j)
    ni(i,j)
    H       entropy

    p2(i,j,m) ;

    p2.lo(i,j,m)=1e-10;

Equations
    obj_gjm    define objective function - golan & judge & miller
    obj_alt    define objective function - alternative;


obj_gjm..    H =e= sum(i, lambda(i)*y1(i))
                 + sum(j, mi(j))
                 + sum((i,j), log(sum(m, exp(-(lambda(i)*x1(j)+mi(j)+ni(i,j)*zero(i,j))*Z_GJM(i,j,m)))));

obj_alt..    H =e= sum(i, lambda(i)*y1(i))
                 + sum(j, mi(j)*x1(j))
                 + sum((i,j)$(N4(i,j) = N5), gamma(i,j))
                 + log(sum((i,j,m)$(Z_ALT(i,j,m) ne 0), exp(-lambda(i)*G1-mi(j)*G1-ni(i,j)*zero(i,j)-(gamma(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5))));

Model SAM_GJM /obj_gjm/ ;
Model SAM_ALT /obj_alt/ ;

Parameter omega(i,j),omega2,p(i,j,m),A1_HAT(i,j,l),B1_HAT(i,j,l);

option NLP=CONOPT;

* Optimalizacia
    lambda.l(i)=0;
    mi.l(j)=0;
    ni.l(i,j)=0;

solve SAM_GJM using NLP minimizing H;

    omega(i,j)=sum(m, exp(-(lambda.l(i)*x1(j)+mi.l(j)+ni.l(i,j)*zero(i,j))*Z_GJM(i,j,m)));
    p(i,j,m)=exp(-(lambda.l(i)*x1(j)+mi.l(j)+ni.l(i,j)*zero(i,j))*Z_GJM(i,j,m))/omega(i,j);
    A1_HAT(i,j,'GJM')=sum(m, Z_GJM(i,j,m)*p(i,j,m));
    B1_HAT(i,j,'GJM')=A1_HAT(i,j,'GJM')*x1(j)*F;

    lambda.l(i)=0;
    mi.l(j)=0;
    ni.l(i,j)=0;

    Z_ALT(i,j,'1') = 0;
    N4(i,j)=sum(m$(Z_ALT(i,j,m) ne 0), 1);
*    zero('D','D')=1;
option NLP=CONOPT2;

solve SAM_ALT using NLP minimizing H;

    omega2=sum((i,j,m)$(Z_ALT(i,j,m) ne 0), exp(-lambda.l(i)*G1-mi.l(j)*G1-ni.l(i,j)*zero(i,j)-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5)));
    p(i,j,m)$(Z_ALT(i,j,m) ne 0)=exp(-log(Z_ALT(i,j,m))-lambda.l(i)*G1-mi.l(j)*G1-ni.l(i,j)*zero(i,j)-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5))/omega2;
    p(i,j,m)$(Z_ALT(i,j,m) = 0)=1-sum(m1, p(i,j,m1)$(Z_ALT(i,j,m1) ne 0));
    A1_HAT(i,j,'ALT')=G1/x1(j)*sum(m, Z_ALT(i,j,m)*p(i,j,m));
    B1_HAT(i,j,'ALT')=A1_HAT(i,j,'ALT')*x1(j)*F;

* RAS pouzit nemozno v pripade ze x1 ma niektory prvok nulovy

*Parameter A1_RAS(i,j),B1_RAS(i,j),R(i),S(j);
*    A1_RAS(i,j)=A0(i,j);

*while(
* smax(i, abs(y1(i)-sum(j, A1_RAS(i,j)*x1(j))))>0.0001 or smax(j, abs(1-sum(i, A1_RAS(i,j))))>0.0001,
* if (smax(i, abs(y1(i)-sum(j, A1_RAS(i,j)*x1(j))))>0.0001,
*       R(i)=y1(i)/sum(j, A1_RAS(i,j)*x1(j));
*       loop(j, A1_RAS(i,j)=A1_RAS(i,j)*R(i));
*     )
* if (smax(j, abs(1-sum(i, A1_RAS(i,j))))>0.0001,
*       S(j)=1/sum(i, A1_RAS(i,j));
*       loop(i, A1_RAS(i,j)=A1_RAS(i,j)*S(j));
*     )
* );

*    B1_RAS(i,j)=A1_RAS(i,j)*x1(j);

Parameter A1_GJM(i,j),A1_ALT(i,j);
    A1_GJM(i,j)=A1_HAT(i,j,'GJM');
$libinclude xlexport A1_GJM C:\MaxEnt\Data\SAM_example.xls data!u3:aa9
    A1_ALT(i,j)=A1_HAT(i,j,'ALT');
$libinclude xlexport A1_ALT C:\MaxEnt\Data\SAM_example.xls data!u16:aa22

* Vypocet parametrov
Parameter  E_A(i,j,l),E_B(i,j,l),
           P_B(i,j,l),
           MAD_A(l),SEM_A(l),
           MAD_B(l),SEM_B(l),
           MaxPE(l),MAPE(l),GOF_A(l),GOF_B(l),
           CORR_A(l),CORR_B(l),
           mean_A1_HAT,mean_B1_HAT,mean_A1,mean_B1;

    E_A(i,j,l) = A1_HAT(i,j,l)-A1(i,j);
    E_B(i,j,l) = B1_HAT(i,j,l)-B1(i,j);
    P_B(i,j,l)$B1(i,j) = abs(E_B(i,j,l))/B1(i,j);

    MAD_A(l) = sum((i,j), abs(E_A(i,j,l)))/N1;
    SEM_A(l) = sum((i,j), power(E_A(i,j,l),2))/N1;

    MAD_B(l) = sum((i,j), abs(E_B(i,j,l)))/N1;
    SEM_B(l) = sum((i,j), power(E_B(i,j,l),2))/N1;

    MaxPE(l) = smax((i,j), P_B(i,j,l));
    MAPE(l) = sum((i,j), P_B(i,j,l))/N1;

    GOF_A(l) = sum((i,j)$A1_HAT(i,j,l), E_A(i,j,l)*E_A(i,j,l)/(N1*A1_HAT(i,j,l)));
    mean_A1_HAT(l)=sum((i,j), A1_HAT(i,j,l))/N1;
    mean_A1=sum((i,j), A1(i,j))/N1;
    CORR_A(l) = (sum((i,j),(A1_HAT(i,j,l)-mean_A1_HAT(l))*(A1(i,j)-mean_A1))/N1)/
      ((sum((i,j),power(A1_HAT(i,j,l)-mean_A1_HAT(l),2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5;

    GOF_B(l) = sum((i,j)$B1_HAT(i,j,l), E_B(i,j,l)*E_B(i,j,l)/(N1*B1_HAT(i,j,l)));
    mean_B1_HAT(l)=sum((i,j), B1_HAT(i,j,l))/N1;
    mean_B1=sum((i,j), B1(i,j))/N1;
    CORR_B(l) = (sum((i,j),(B1_HAT(i,j,l)-mean_B1_HAT(l))*(B1(i,j)-mean_B1))/N1)/
      ((sum((i,j),power(B1_HAT(i,j,l)-mean_B1_HAT(l),2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5;


option decimals=5

display MAD_A,SEM_A,MAD_B,SEM_B,MaxPE,MAPE,GOF_A,GOF_B,CORR_A,CORR_B;